package com.xebialabs.xlrelease.status.service.script

import com.fasterxml.jackson.core.`type`.TypeReference
import com.xebialabs.xlrelease.runner.impl.RunnerScriptService
import com.xebialabs.xlrelease.script.XlrScriptContext
import com.xebialabs.xlrelease.script.jython.{JythonScriptService, XlrJythonSupport}
import com.xebialabs.xlrelease.status.service.script.FiltersRequestScriptExecutor.createFiltersScriptContext
import com.xebialabs.xlrelease.status.webhook.events.{RemoteStatusWebhookEventSource, StatusWebhookEventSource}
import grizzled.slf4j.Logging
import io.micrometer.core.annotation.Timed
import org.springframework.stereotype.Component

import java.util

trait FiltersRequestScriptService {
  @throws(classOf[Exception])
  def executeScript(eventSource: StatusWebhookEventSource): AnyRef
}

@Component
class FiltersRequestScriptExecutor(
                             val scriptService: JythonScriptService,
                             runnerScriptService: RunnerScriptService
                           ) extends XlrJythonSupport with FiltersRequestScriptService with Logging {

  @Timed
  @throws(classOf[Exception])
  override def executeScript(connection: StatusWebhookEventSource): AnyRef = {
    logger.debug(s"Executing filters request script for StatusWebhookEventSource ${connection.getName}")
    if (connection.isInstanceOf[RemoteStatusWebhookEventSource]) {
      runnerScriptService.executeScript[util.List[String]](
        connection.filtersRequest,
        buildDefaultInputParams(connection),
        new TypeReference[util.List[String]] {}
      )
    } else {
      val scriptContext = createFiltersScriptContext(connection)
      executeScript(scriptContext)
      scriptContext.getAttribute("data")
    }
  }
}

private class FiltersRequestContextBuilder(connection: StatusWebhookEventSource) extends BaseScriptContextBuilder(connection) {

  override val scriptProperty: String = FiltersRequestScriptProperty

  override protected def doBuild(context: XlrScriptContext): Unit = {
    addConnectionServerAttributes(context)
    addScript(context)
  }
}

private object FiltersRequestScriptExecutor {
  def createFiltersScriptContext(connection: StatusWebhookEventSource): XlrScriptContext = {
    new FiltersRequestContextBuilder(connection).build()
  }
}
