package com.xebialabs.xlrelease.applications.management.security

import com.xebialabs.deployit.security.PermissionDeniedException
import com.xebialabs.xlrelease.security.PermissionChecker
import com.xebialabs.xlrelease.security.XLReleasePermissions.{EDIT_APP_PIPELINES, VIEW_APP_PIPELINES}
import com.xebialabs.xlrelease.utils.FolderId
import org.springframework.stereotype.Component

@Component
class ManagedApplicationPermissionChecker (permissions: PermissionChecker) {
  def checkManageAppPipelinesPermission(folderId: String): Unit = {
    if (!permissions.isCurrentUserAdmin && !permissions.hasPermission(EDIT_APP_PIPELINES, FolderId(folderId).absolute)) {
      throw PermissionDeniedException.withMessage(s"You do not have $EDIT_APP_PIPELINES permission on ${folderId}")
    }
  }

  def checkViewAppPipelinesPermission(folderId: String): Unit = {
    if (!permissions.isCurrentUserAdmin && !permissions.hasPermission(VIEW_APP_PIPELINES, FolderId(folderId).absolute)) {
      throw PermissionDeniedException.withMessage(s"You do not have $VIEW_APP_PIPELINES permission on ${folderId}")
    }
  }
}
