package com.xebialabs.xlrelease.status.service

import com.xebialabs.deployit.plugin.api.reflect.PropertyKind
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem
import com.xebialabs.xlrelease.json.JsonUtils.objectMapper
import com.xebialabs.xlrelease.script.EncryptionHelper
import com.xebialabs.xlrelease.status.webhook.events.StatusWebhookEventSource

import java.util
import scala.jdk.CollectionConverters._

package object script {

  private val MAX_ERROR_MESSAGE_LENGTH: Int = 500

  private def ciAsMap(ciPropertyItem: ConfigurationItem): util.Map[String, AnyRef] = {
    val ciProperties = new util.HashMap[String, AnyRef]()
    Option(ciPropertyItem).map(ciProperty => {
      EncryptionHelper.decrypt(ciProperty)
      ciProperties.put("id", ciProperty.getId)
      ciProperties.put("type", ciProperty.getType.toString)
      val descriptor = ciProperty.getType.getDescriptor
      for (ciPropertyDescriptor <- descriptor.getPropertyDescriptors.asScala) {
        if (ciPropertyDescriptor.getKind.equals(PropertyKind.CI) && !ciPropertyDescriptor.isAsContainment) {
          ciProperties.put(ciPropertyDescriptor.getName, ciAsMap(ciProperty.getProperty(ciPropertyDescriptor.getName).asInstanceOf[ConfigurationItem]))
        } else if (!ciPropertyDescriptor.getKind.equals(PropertyKind.CI)) {
          ciProperties.put(ciPropertyDescriptor.getName, ciProperty.getProperty(ciPropertyDescriptor.getName))
        }
      }
      ciProperties
    }).orNull
  }

  def buildDefaultInputParams(statusWebhookEventSource: StatusWebhookEventSource): util.Map[String, AnyRef] = {
    val inputParameters: util.Map[String, AnyRef] = new util.HashMap[String, AnyRef]()
    inputParameters.put("statusWebhookEventSource", objectMapper.writeValueAsString(ciAsMap(statusWebhookEventSource))) // writing it as json string
    inputParameters.put("server", statusWebhookEventSource.sourceServer)
    inputParameters
  }

  def formatErrorMessage(errorMessage: String): String = {
    if (errorMessage.length <= MAX_ERROR_MESSAGE_LENGTH) {
      errorMessage
    } else {
      val truncatedMessage = errorMessage.substring(0, MAX_ERROR_MESSAGE_LENGTH - 1) + "..."
      s"$truncatedMessage\n(Check logs for more details)"
    }
  }

}
