package com.xebialabs.xlrelease.upgrade

import com.xebialabs.deployit.server.api.upgrade.{Upgrade, Version}
import com.xebialabs.xlrelease.applications.management.repository.persistence.ApplicationsManagementPersistence
import com.xebialabs.xlrelease.upgrade.Components.XL_RELEASE_COMPONENT
import grizzled.slf4j.Logging
import org.springframework.stereotype.Component

import scala.util.{Failure, Try}

@Component
class XLRelease241ManagedApplicationsFolderUpgrade(applicationsManagementPersistence: ApplicationsManagementPersistence) extends Upgrade with Logging {
  override def doUpgrade(): Boolean = {
    Try(upgradeManagedApplicationsFolders()) match {
      case Failure(_) => logger.error("Unable to upgrade Managed Applications folders")
      case _ =>
    }
    true
  }

  private def upgradeManagedApplicationsFolders(): Unit = {
    applicationsManagementPersistence.findWithFolderConnections.foreach(ma => {
      applicationsManagementPersistence.update(
        ma.copy(folderId = applicationsManagementPersistence.findConnectionFolderId(ma.id).get)
      )
    })
  }

  override def upgradeVersion(): Version = Version.valueOf(XL_RELEASE_COMPONENT, "24.1.0#5")
}
