import { createSlice, PayloadAction } from '@reduxjs/toolkit';
import noop from 'lodash/noop';
import { ManagedApplicationsPage, ManagedApplicationType, Template, WebhookSourceWithFolder } from '../managed-application.types';
import { ExternalDeploymentPage } from '../../external-deployments/external-deployment.types';
import { APPLICATION_MANAGEMENT_SLICE_NAME, DEFAULT_MANAGED_APPLICATIONS_PAGE } from '../constants';
import { PluginInfo } from '../../external-deployments/components/wizard/basic-wizard/application-discovery-basic.component';
import { DEFAULT_CONDITION } from '../../external-deployments/constants';
import { Folder } from '../../../../../../../../../core/xlr-ui/app/types';

export interface ApplicationManagementState {
    condition: string;
    count: number;
    folderId?: string;
    hasEditPipelinesPermission: boolean;
    isLoading: boolean;
    managedApplications: Array<ManagedApplicationType>;
    page: ManagedApplicationsPage;
    templates: Array<Template>;
    totalCount: number;
    validServerCards: PluginInfo[];
}

export const initialState: ApplicationManagementState = {
    condition: DEFAULT_CONDITION,
    count: 0,
    folderId: undefined,
    hasEditPipelinesPermission: true,
    isLoading: false,
    managedApplications: [],
    page: DEFAULT_MANAGED_APPLICATIONS_PAGE,
    templates: [],
    totalCount: 0,
    validServerCards: [],
};

export interface NavigateToWorkflowPayload {
    actionName: string;
    managedApplicationId: string;
    workflowId?: string;
}

export const applicationManagement = createSlice({
    name: APPLICATION_MANAGEMENT_SLICE_NAME,
    initialState,
    reducers: {
        setPage: (state: ApplicationManagementState, action: PayloadAction<ExternalDeploymentPage>) => {
            state.page = action.payload;
        },
        loadManagedApplications: (_state: ApplicationManagementState) => noop(),
        navigateToWorkflow: (_state: ApplicationManagementState, _action: PayloadAction<NavigateToWorkflowPayload>) => noop(),
        setCondition: (state: ApplicationManagementState, action: PayloadAction<string>) => {
            state.condition = action.payload;
        },
        setIsLoading: (state: ApplicationManagementState, action: PayloadAction<boolean>) => {
            state.isLoading = action.payload;
        },
        setManagedApplications: (state: ApplicationManagementState, action: PayloadAction<Array<ManagedApplicationType>>) => {
            state.managedApplications = action.payload;
        },
        setManagedApplicationsCount: (state: ApplicationManagementState, action: PayloadAction<number>) => {
            state.count = action.payload;
        },
        setManagedApplicationsTotalCount: (state: ApplicationManagementState, action: PayloadAction<number>) => {
            state.totalCount = action.payload;
        },
        storeFilters: (_state: ApplicationManagementState) => noop(),
        getFilters: (state: ApplicationManagementState, action: PayloadAction<string>) => {
            state.page.folderId = action.payload;
        },
        createManagedApplicationsFromWebhookSource: (_state: ApplicationManagementState, _action: PayloadAction<WebhookSourceWithFolder>) => noop(),
        loadEditPermission: (_state: ApplicationManagementState, _action: PayloadAction<Folder>) => noop(),
        setEditPermission: (state: ApplicationManagementState, action: PayloadAction<boolean>) => {
            state.hasEditPipelinesPermission = action.payload;
        },
    },
});
