package com.xebialabs.xlrelease.api

import com.xebialabs.xlrelease.api.internal.views._
import com.xebialabs.xlrelease.api.v1.views.{ConnectionServerView, ManagedApplicationPage, ManagedApplicationView}
import com.xebialabs.xlrelease.applications.management.service.{ApplicationsManagement, ManagedApplicationData}
import com.xebialabs.xlrelease.status.service.{
  ConnectionServerData, EndpointExternalDeployment, EndpointUpdateStatusEvent,
  WebhookBasicSetup, WebhookSourceFilters
}
import com.xebialabs.xlrelease.status.webhook.events.{StateMetadata, VersionState}

import java.util.stream.Collectors
import java.util.{List => JList, Map => JMap}
import scala.jdk.CollectionConverters._
import scala.language.implicitConversions

package object internal {
  implicit def externalDeploymentViewMapper(status: EndpointExternalDeployment): ExternalDeploymentView =
    ExternalDeploymentView.create(
      status.count,
      status.connectionServers,
      status.states,
      status.connectionServers.flatMap(_._2.error).toList.asJava,
      status.connectionServers.filter(_._2.error.isDefined).map(_._2.connectionId).toList.asJava)

  implicit def connectionServerViewMapMapper(connectionServers: Map[Integer, ConnectionServerData]): JMap[Integer, ConnectionServerView] =
    connectionServers.map(entry => entry._1 -> connectionServerViewMapper(entry._2)).asJava

  implicit def baseExternalDeploymentViewsMapper(statues: Vector[EndpointUpdateStatusEvent]): JList[ExternalDeploymentDataView] =
    statues.map(baseExternalDeploymentViewMapper).toList.asJava

  implicit def connectionServerViewMapper(connectionServerData: ConnectionServerData): ConnectionServerView =
    new ConnectionServerView(connectionServerData.connectionId, connectionServerData.title, connectionServerData.serverType, connectionServerData.serverUrl)

  implicit def baseExternalDeploymentViewMapper(status: EndpointUpdateStatusEvent): ExternalDeploymentDataView =
    ExternalDeploymentDataView.create(
      status.endpointId,
      status.event.applicationName,
      status.event.applicationUid,
      status.event.applicationPath,
      status.event.statusGroup,
      status.event.state
    )

  implicit def deploymentStateViewMapper(state: StateMetadata): DeploymentStateView =
    DeploymentStateView.create(
      state.destination,
      state.destinationUid,
      state.namespace,
      state.versionTag,
      state.deploymentStatus,
      state.deploymentType,
      state.user,
      state.lastChangeTime
    )

  implicit def statefulLabelViewMapper(versionTag: VersionState): StatefulLabelView =
    StatefulLabelView.create(versionTag.label, versionTag.state)

  implicit def webhookSourceFiltersViewMapper(filters: WebhookSourceFilters): WebhookSourceFiltersView =
    WebhookSourceFiltersView.create(
      filters.webhookSourceId,
      filters.folderFilterOptions.asJava,
      filters.folderFilterValues.asJava
    )

  implicit def webhookQuickSetupViewMapper(webhookQuickSetup: WebhookBasicSetup): WebhookBasicSetupView =
    WebhookBasicSetupView.create(
      webhookQuickSetup.success,
      webhookQuickSetup.message,
      webhookQuickSetup.details,
      webhookQuickSetup.url,
      webhookQuickSetup.webhookSourceId
    )

  implicit def applicationsManagementViewMapper(applicationsManagement: ApplicationsManagement): ManagedApplicationPage =
    ManagedApplicationPage.create(
      applicationsManagement.totalCount,
      applicationsManagement.count,
      applicationsManagement.managedApplications.stream().map(managedApplicationViewMapper).collect(Collectors.toList()))

  implicit def managedApplicationViewMapper(managedApplication: ManagedApplicationData): ManagedApplicationView =
    ManagedApplicationView.create(
      managedApplication.id,
      managedApplication.applicationName,
      managedApplication.managedBy,
      managedApplication.dateCreated,
      managedApplication.environmentTag,
      managedApplication.applicationReference,
      connectionServerViewMapper(managedApplication.connectionServer),
      managedApplication.workflowId,
      managedApplication.deleteWorkflowId,
      managedApplication.updateWorkflowId,
      managedApplication.folderId)

}
