import React, { memo } from 'react';
import './application-create-server-component.less';
import './application-create-server-component.less';
import { Folder } from '../../../../../../../../../../../core/xlr-ui/app/types';
import { ConnectionDialog } from '../../../../../../../../../../../core/xlr-ui/app/features/tasks/components/rails/common/connection-dialog/connection-dialog.component';
import { folderExternalDeployments } from '../../../ducks/external-deployments.reducer';

export interface ApplicationCreateServerFormProp {
    closeForm: () => void;
    folder: Folder;
    serverId?: string;
    serverType?: string;
}

const CreateServerFormComponent = (props: ApplicationCreateServerFormProp) => {
    const { serverType, closeForm, serverId } = props;
    const { updateServerList } = folderExternalDeployments.actions;

    const handleCancelConfiguration = (): void => {
        closeForm();
    };

    const handleSaveConfiguration = (): void => {
        closeForm();
    };

    return (
        <ConnectionDialog
            configurationSaveAction={updateServerList}
            connectionId={serverId}
            isNewInstance={!serverId}
            keyOrName={'server'}
            onCancel={handleCancelConfiguration}
            onSave={handleSaveConfiguration}
            referencedType={serverType || ''}
        />
    );
};

export const CreateServerForm = memo(CreateServerFormComponent);
