import React from 'react';
import { ReactWrapper } from 'enzyme';
import { Provider } from 'react-redux';
import { mountWithStoreAndTheme } from '../../../../../../../../../../core/xlr-ui/tests/unit/testing-utils';
import { ManagedApplication, ManagedApplicationProps } from './managed-application.component';
import { pluginInfoArgo } from '../../../external-deployments/__mocks__/discovery-wizard.mocks';

describe('ManagedApplication component', () => {
    let wrapper: ReactWrapper;
    const defaultState = {
        validServerCards: [pluginInfoArgo],
        hasEditPipelinesPermission: true,
    };
    const dispatch = jest.fn();

    const defaultProps: ManagedApplicationProps = {
        folder: { id: 'folderId', title: 'Folder' },
        managedApplication: {
            applicationName: 'Mario Deluxe',
            applicationReference: 'Argo CD',
            connectionServer: {
                id: 'Configuration/Custom/Configurationb128a7f883814423bd8badda97cbd816',
                name: 'Bruno test',
                type: 'argocd.ArgoCD',
                url: 'www.google.hr',
            },
            dateCreated: new Date(),
            environmentTag: 'DEV',
            id: '',
            managedBy: 'Release',
            folderId: 'folderId',
        },
    };

    const mountComponent = (state = defaultState) => {
        wrapper = mountWithStoreAndTheme(<ManagedApplication {...defaultProps} />, dispatch, { applicationManagement: state });
    };

    const getOptionsButton = () => wrapper.find('DotIconButton [iconId="options"]');

    afterEach(() => {
        wrapper.unmount();
    });

    it('should render properly', () => {
        mountComponent();

        expect(wrapper.find(Provider)).toExist();
        expect(wrapper.find(ManagedApplication)).toExist();
    });

    it('should show actions button when user does have edit permissions', () => {
        mountComponent();

        const button = getOptionsButton();
        expect(button).toExist();
    });

    it('should hide actions button when user does NOT have edit permissions', () => {
        mountComponent({ ...defaultState, hasEditPipelinesPermission: false });

        const button = getOptionsButton();
        expect(button).not.toExist();
    });
});
