import React from 'react';
import noop from 'lodash/noop';
import { ReactWrapper } from 'enzyme';
import { Provider } from 'react-redux';
import { mountWithStoreAndTheme } from '../../../../../../../../../../core/xlr-ui/tests/unit/testing-utils';
import { ManagedApplicationTable, ManagedApplicationTableProps } from './managed-application-table.component';

describe('ManagedApplicationTable component', () => {
    let wrapper: ReactWrapper;
    const dispatch = jest.fn();
    const defaultProps: ManagedApplicationTableProps = {
        folder: { id: 'folderId', title: 'Folder' },
        setCreateApplicationView: noop,
    };
    const mountComponent = () => {
        wrapper = mountWithStoreAndTheme(<ManagedApplicationTable {...defaultProps} />, dispatch, {
            applicationManagement: {
                managedApplications: [],
                page: {},
                condition: '',
            },
        });
    };
    beforeEach(() => {
        mountComponent();
    });

    afterEach(() => {
        wrapper.unmount();
    });

    it('should render properly', () => {
        expect(wrapper.find(Provider)).toExist();
        expect(wrapper.find(ManagedApplicationTable)).toExist();
    });
});
