package com.xebialabs.xlrelease.api.internal.views;

import java.util.Date;

public class DeploymentStateView {
    private String destination;
    private String destinationUid;
    private String namespace;
    private StatefulLabelView versionTag;
    private String deploymentStatus;
    private String deploymentType;
    private String user;
    private Date lastChangeTime;

    public static DeploymentStateView create(
            String destination,
            String destinationUid,
            String namespace,
            StatefulLabelView versionTag,
            String deploymentStatus,
            String deploymentType,
            String user,
            Date lastChangeTime) {
        DeploymentStateView view = new DeploymentStateView();
        view.setDestination(destination);
        view.setDestinationUid(destinationUid);
        view.setNamespace(namespace);
        view.setVersionTag(versionTag);
        view.setDeploymentStatus(deploymentStatus);
        view.setDeploymentType(deploymentType);
        view.setUser(user);
        view.setLastChangeTime(lastChangeTime);
        return view;
    }

    public String getDestination() {
        return destination;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    public String getNamespace() {
        return namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public StatefulLabelView getVersionTag() {
        return versionTag;
    }

    public void setVersionTag(StatefulLabelView versionTag) {
        this.versionTag = versionTag;
    }

    public String getDeploymentStatus() {
        return deploymentStatus;
    }

    public void setDeploymentStatus(String deploymentStatus) {
        this.deploymentStatus = deploymentStatus;
    }

    public String getDeploymentType() {
        return deploymentType;
    }

    public void setDeploymentType(String deploymentType) {
        this.deploymentType = deploymentType;
    }

    public String getUser() {
        return user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public Date getLastChangeTime() {
        return lastChangeTime;
    }

    public void setLastChangeTime(Date lastChangeTime) {
        this.lastChangeTime = lastChangeTime;
    }

    public String getDestinationUid() {
        return destinationUid;
    }

    public void setDestinationUid(final String destinationUid) {
        this.destinationUid = destinationUid;
    }
}
