import React from 'react';
import { shallow, ShallowWrapper } from 'enzyme';
import { Provider } from 'react-redux';
import { FolderApplicationsManagementPage } from './folder-applications-management';
import { ApplicationsPageWrapper } from './created-applications-table/applications-page-wrapper.component';

describe('FolderApplicationsManagementPage component', () => {
    let wrapper: ShallowWrapper;
    const defaultProps = {
        folder: { id: 'folderId', title: 'Folder' },
    };
    beforeEach(() => {
        wrapper = shallow(<FolderApplicationsManagementPage {...defaultProps} />);
    });

    afterEach(() => {
        wrapper.unmount();
    });

    it('should render properly', () => {
        expect(wrapper.find(Provider)).toExist();
        expect(wrapper.find(ApplicationsPageWrapper)).toExist();
    });
});
