/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.applications.management.service;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.xlrelease.applications.management.repository.persistence.ApplicationsManagementPersistence;
import com.xebialabs.xlrelease.applications.management.service.ApplicationsManagement;
import com.xebialabs.xlrelease.applications.management.service.ApplicationsManagementService;
import com.xebialabs.xlrelease.applications.management.service.ManagedApplication;
import com.xebialabs.xlrelease.applications.management.service.ManagedApplicationData;
import com.xebialabs.xlrelease.repository.ConfigurationRepository;
import com.xebialabs.xlrelease.status.service.ConnectionServerData;
import com.xebialabs.xlrelease.status.webhook.configuration.StatusHttpConnection;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import org.slf4j.Marker;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.immutable.Vector;
import scala.reflect.ScalaSignature;

@Service
@ScalaSignature(bytes="\u0006\u0005\u0005\u0015a\u0001\u0002\u0006\f\u0001aA\u0001b\u000b\u0001\u0003\u0002\u0003\u0006I\u0001\f\u0005\te\u0001\u0011\t\u0011)A\u0005g!)!\b\u0001C\u0001w!)q\b\u0001C!\u0001\")Q\f\u0001C!=\")q\r\u0001C!Q\")!\u000e\u0001C!W\")\u0011\u000f\u0001C\u0005e\")A\u000f\u0001C\u0005k\n\u0001\u0013\t\u001d9mS\u000e\fG/[8o\u001b\u0006t\u0017mZ3nK:$8+\u001a:wS\u000e,\u0017*\u001c9m\u0015\taQ\"A\u0004tKJ4\u0018nY3\u000b\u00059y\u0011AC7b]\u0006<W-\\3oi*\u0011\u0001#E\u0001\rCB\u0004H.[2bi&|gn\u001d\u0006\u0003%M\t\u0011\u0002\u001f7sK2,\u0017m]3\u000b\u0005Q)\u0012!\u0003=fE&\fG.\u00192t\u0015\u00051\u0012aA2p[\u000e\u00011\u0003\u0002\u0001\u001a?\r\u0002\"AG\u000f\u000e\u0003mQ\u0011\u0001H\u0001\u0006g\u000e\fG.Y\u0005\u0003=m\u0011a!\u00118z%\u00164\u0007C\u0001\u0011\"\u001b\u0005Y\u0011B\u0001\u0012\f\u0005u\t\u0005\u000f\u001d7jG\u0006$\u0018n\u001c8t\u001b\u0006t\u0017mZ3nK:$8+\u001a:wS\u000e,\u0007C\u0001\u0013*\u001b\u0005)#B\u0001\u0014(\u0003\u0015\u0019HN\u001a\u001bk\u0015\u0005A\u0013\u0001C4sSjTH.\u001a3\n\u0005)*#a\u0002'pO\u001eLgnZ\u0001\u0018G>tg-[4ve\u0006$\u0018n\u001c8SKB|7/\u001b;pef\u0004\"!\f\u0019\u000e\u00039R!aL\t\u0002\u0015I,\u0007o\\:ji>\u0014\u00180\u0003\u00022]\t92i\u001c8gS\u001e,(/\u0019;j_:\u0014V\r]8tSR|'/_\u0001\"CB\u0004H.[2bi&|gn]'b]\u0006<W-\\3oiB+'o]5ti\u0016t7-\u001a\t\u0003iaj\u0011!\u000e\u0006\u0003m]\n1\u0002]3sg&\u001cH/\u001a8dK*\u0011q&D\u0005\u0003sU\u0012\u0011%\u00119qY&\u001c\u0017\r^5p]Nl\u0015M\\1hK6,g\u000e\u001e)feNL7\u000f^3oG\u0016\fa\u0001P5oSRtDc\u0001\u001f>}A\u0011\u0001\u0005\u0001\u0005\u0006W\r\u0001\r\u0001\f\u0005\u0006e\r\u0001\raM\u0001\u0017O\u0016$X*\u00198bO\u0016$\u0017\t\u001d9mS\u000e\fG/[8ogR!\u0011\tR)\\!\t\u0001#)\u0003\u0002D\u0017\t1\u0012\t\u001d9mS\u000e\fG/[8og6\u000bg.Y4f[\u0016tG\u000fC\u0003F\t\u0001\u0007a)\u0001\u0005g_2$WM]%e!\t9eJ\u0004\u0002I\u0019B\u0011\u0011jG\u0007\u0002\u0015*\u00111jF\u0001\u0007yI|w\u000e\u001e \n\u00055[\u0012A\u0002)sK\u0012,g-\u0003\u0002P!\n11\u000b\u001e:j]\u001eT!!T\u000e\t\u000bI#\u0001\u0019A*\u0002\tA\fw-\u001a\t\u0003)fk\u0011!\u0016\u0006\u0003-^\u000bA\u0001\\1oO*\t\u0001,\u0001\u0003kCZ\f\u0017B\u0001.V\u0005\u0011auN\\4\t\u000bq#\u0001\u0019A*\u0002\u001dI,7/\u001e7ugB+'\u000fU1hK\u0006)\u0012\r\u001a3NC:\fw-\u001a3BaBd\u0017nY1uS>tGCA0c!\t\u0001\u0003-\u0003\u0002b\u0017\t1R*\u00198bO\u0016$\u0017\t\u001d9mS\u000e\fG/[8o\t\u0006$\u0018\rC\u0003d\u000b\u0001\u0007A-\u0001\nnC:\fw-\u001a3BaBd\u0017nY1uS>t\u0007C\u0001\u0011f\u0013\t17B\u0001\nNC:\fw-\u001a3BaBd\u0017nY1uS>t\u0017\u0001G;qI\u0006$X-T1oC\u001e,G-\u00119qY&\u001c\u0017\r^5p]R\u0011q,\u001b\u0005\u0006G\u001a\u0001\r\u0001Z\u0001\u0019I\u0016dW\r^3NC:\fw-\u001a3BaBd\u0017nY1uS>tGC\u00017p!\tQR.\u0003\u0002o7\t!QK\\5u\u0011\u0015\u0001x\u00011\u0001G\u0003Qi\u0017M\\1hK\u0012\f\u0005\u000f\u001d7jG\u0006$\u0018n\u001c8JI\u0006Qb/\u00197jI\u0006$X-T1oC\u001e,G-\u00119qY&\u001c\u0017\r^5p]R\u0011An\u001d\u0005\u0006G\"\u0001\r\u0001Z\u0001+[\u0006t\u0017mZ3e\u0003B\u0004H.[2bi&|g\u000eV8NC:\fw-\u001a3BaBd\u0017nY1uS>tG)\u0019;b)\tyf\u000fC\u0003d\u0013\u0001\u0007A\r\u000b\u0002\u0001qB\u0019\u00110!\u0001\u000e\u0003iT!a\u001f?\u0002\u0015M$XM]3pif\u0004XM\u0003\u0002~}\u0006y1\u000f\u001d:j]\u001e4'/Y7fo>\u00148NC\u0001\u0000\u0003\ry'oZ\u0005\u0004\u0003\u0007Q(aB*feZL7-\u001a")
public class ApplicationManagementServiceImpl
implements ApplicationsManagementService,
Logging {
    private final ConfigurationRepository configurationRepository;
    private final ApplicationsManagementPersistence applicationsManagementPersistence;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        ApplicationManagementServiceImpl applicationManagementServiceImpl = this;
        synchronized (applicationManagementServiceImpl) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    @Override
    public ApplicationsManagement getManagedApplications(String folderId, Long page, Long resultsPerPage) {
        int count = this.applicationsManagementPersistence.countForFolder(folderId);
        Vector managedApplications = (Vector)this.applicationsManagementPersistence.findForFolder(folderId, Predef$.MODULE$.Long2long(resultsPerPage), Predef$.MODULE$.Long2long(resultsPerPage) * Predef$.MODULE$.Long2long(page)).map((Function1 & Serializable)ma -> this.managedApplicationToManagedApplicationData((ManagedApplication)ma));
        return new ApplicationsManagement(count, (Vector<ManagedApplicationData>)managedApplications);
    }

    @Override
    public ManagedApplicationData addManagedApplication(ManagedApplication managedApplication) {
        this.validateManagedApplication(managedApplication);
        String managedApplicationId = this.applicationsManagementPersistence.create(managedApplication);
        ManagedApplication created = (ManagedApplication)this.applicationsManagementPersistence.findById(managedApplicationId).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException("Managed Application with id [" + managedApplicationId + "] not found", new Object[0]);
        });
        return this.managedApplicationToManagedApplicationData(created);
    }

    @Override
    public ManagedApplicationData updateManagedApplication(ManagedApplication managedApplication) {
        Checks.checkArgument((boolean)StringUtils.hasText((String)managedApplication.id()), (String)"ID is required", (Object[])new Object[0]);
        this.validateManagedApplication(managedApplication);
        this.applicationsManagementPersistence.update(managedApplication);
        return this.managedApplicationToManagedApplicationData(managedApplication);
    }

    @Override
    public void deleteManagedApplication(String managedApplicationId) {
        Checks.checkArgument((boolean)StringUtils.hasText((String)managedApplicationId), (String)"ID is required", (Object[])new Object[0]);
        this.applicationsManagementPersistence.delete(managedApplicationId);
    }

    private void validateManagedApplication(ManagedApplication managedApplication) {
        Checks.checkArgument((boolean)StringUtils.hasText((String)managedApplication.applicationName()), (String)"Application name cannot be blank", (Object[])new Object[0]);
        Checks.checkArgument((boolean)Option$.MODULE$.apply((Object)managedApplication.connectionServer()).isDefined(), (String)"Connection server must be defined", (Object[])new Object[0]);
    }

    private ManagedApplicationData managedApplicationToManagedApplicationData(ManagedApplication managedApplication) {
        StatusHttpConnection connection = (StatusHttpConnection)this.configurationRepository.read((String)this.applicationsManagementPersistence.findConnectionId(managedApplication.id()).get());
        return new ManagedApplicationData(managedApplication.id(), managedApplication.applicationName(), managedApplication.managedBy(), managedApplication.dateCreated(), managedApplication.environmentTag(), managedApplication.applicationReference(), new ConnectionServerData(connection.getId(), connection.getTitle(), connection.getType().toString(), connection.getUrl(), (Option<String>)None$.MODULE$));
    }

    public ApplicationManagementServiceImpl(ConfigurationRepository configurationRepository, ApplicationsManagementPersistence applicationsManagementPersistence) {
        this.configurationRepository = configurationRepository;
        this.applicationsManagementPersistence = applicationsManagementPersistence;
        Logging.$init$((Logging)this);
    }
}

