import { SagaIterator } from 'redux-saga';
import { all, call, select, takeEvery, takeLatest } from 'redux-saga/effects';
import { applicationManagement } from './managed-application.reducer';
import { managedApplicationSaga, executeFetchManagedApplicationsAction, getFiltersAction, storeFiltersAction } from './managed-application.saga';

import getAngularService from '../../../../../../../../../core/xlr-ui/app/features/common/services/angular-accessor';
import { ExternalDeploymentPage } from '../../external-deployments/external-deployment.types';
import { getApplicationManagementState } from './managed-application.selectors';

const {
    getFilters,
    loadManagedApplications,

    storeFilters,
} = applicationManagement.actions;

describe('applicationManagementSaga', () => {
    it('should yield all effects', () => {
        const gen: SagaIterator = managedApplicationSaga();
        expect(gen.next().value).toStrictEqual(
            all([
                takeLatest(loadManagedApplications, executeFetchManagedApplicationsAction),
                takeEvery(storeFilters, storeFiltersAction),
                takeEvery(getFilters, getFiltersAction),
            ]),
        );
        expect(gen.next().done).toBe(true);
    });

    describe('storeFiltersAction', () => {
        const condition = 'condition';
        const page: ExternalDeploymentPage = {
            folderId: 'folder-1',
            order: 'asc',
            orderBy: 'environment',
            page: 0,
            resultsPerPage: 10,
        };
        const setManagedApplicationsFilters = jest.fn();
        const update = jest.fn();
        const clientSettings = {
            setManagedApplicationsFilters,
        };
        const filtersQueryParams = {
            update,
        };

        it('should store filters to local storage', () => {
            const gen: SagaIterator = storeFiltersAction();
            expect(gen.next().value).toStrictEqual(select(getApplicationManagementState));
            expect(gen.next({ page, condition }).value).toStrictEqual(call(getAngularService, 'ClientSettings'));
            expect(gen.next(clientSettings).value).toStrictEqual(call(getAngularService, 'FiltersQueryParams'));
            expect(gen.next(filtersQueryParams).done).toBeTruthy();
            expect(update).toHaveBeenCalled();
        });
    });
});
