import { createSlice, PayloadAction } from '@reduxjs/toolkit';
import noop from 'lodash/noop';
import { ManagedApplicationsPage, ManagedApplicationType, Template } from '../managed-application.types';
import { ExternalDeploymentPage } from '../../external-deployments/external-deployment.types';
import { APPLICATION_MANAGEMENT_SLICE_NAME, DEFAULT_MANAGED_APPLICATIONS_PAGE } from '../constants';

export interface ApplicationManagementState {
    applicationPipelineTag: string;
    count: number;
    folderId?: string;
    isLoading: boolean;
    managedApplications: Array<ManagedApplicationType>;
    page: ManagedApplicationsPage;
    templates: Array<Template>;
}

export const initialState: ApplicationManagementState = {
    applicationPipelineTag: '',
    count: 0,
    folderId: undefined,
    isLoading: false,
    managedApplications: [],
    page: DEFAULT_MANAGED_APPLICATIONS_PAGE,
    templates: [],
};

export const applicationManagement = createSlice({
    name: APPLICATION_MANAGEMENT_SLICE_NAME,
    initialState,
    reducers: {
        setPage: (state: ApplicationManagementState, action: PayloadAction<ExternalDeploymentPage>) => {
            state.page = action.payload;
        },
        loadManagedApplications: (_state: ApplicationManagementState) => noop(),
        setIsLoading: (state: ApplicationManagementState, action: PayloadAction<boolean>) => {
            state.isLoading = action.payload;
        },
        setManagedApplications: (state: ApplicationManagementState, action: PayloadAction<Array<ManagedApplicationType>>) => {
            state.managedApplications = action.payload;
        },
        setManagedApplicationsCount: (state: ApplicationManagementState, action: PayloadAction<number>) => {
            state.count = action.payload;
        },
        storeFilters: (_state: ApplicationManagementState) => noop(),
        getFilters: (state: ApplicationManagementState, action: PayloadAction<string>) => {
            state.page.folderId = action.payload;
        },
    },
});
