import React, { useEffect, useState } from 'react';
import { DotThemeProvider } from '@digital-ai/dot-components';
import { FolderExternalDeploymentsProps } from '../../../external-deployments/components/folder-external-deployments';
import { ManagedApplicationTable } from './managed-application-table.component';
import { ApplicationsPageComponent } from '../applications-page/applications-page.component';
import { useAppDispatch, useAppSelector } from '../../../../../../../../../../core/xlr-ui/app/js/hooks';
import { getCreatedApplicationsCountSelector, getCreatedApplicationsLoadingSelector } from '../../ducks/managed-application.selectors';
import { applicationManagement } from '../../ducks/managed-application.reducer';
import { BasicDiscovery } from '../../../external-deployments/components/wizard/basic-wizard/application-discovery-basic.component';
import { WorkflowDrawer } from '../../../../../../../../../../core/xlr-ui/app/features/workflow/workflow-drawer.component';
import { DEFAULT_APPLICATION_SEARCH } from '../../constants';

const { loadManagedApplications, getFilters } = applicationManagement.actions;

export const ApplicationsPageWrapper = ({ folder }: FolderExternalDeploymentsProps) => {
    const dispatch = useAppDispatch();

    useEffect(() => {
        if (folder) {
            dispatch(getFilters(folder.id));
            dispatch(loadManagedApplications());
        }
    }, [folder]);

    const [isWizardView, setIsWizardView] = useState<boolean>(false);
    const [createApplicationView, setCreateApplicationView] = useState<boolean>(false);
    const loading = useAppSelector(getCreatedApplicationsLoadingSelector);
    const dataSize = useAppSelector(getCreatedApplicationsCountSelector);
    const hasAnyData = dataSize > 0;

    const renderData = () => (
        <DotThemeProvider>
            {hasAnyData ? (
                <ManagedApplicationTable folder={folder} setCreateApplicationView={setCreateApplicationView} />
            ) : (
                <ApplicationsPageComponent onViewChange={() => setIsWizardView(true)} setCreateApplicationView={setCreateApplicationView} />
            )}
            <WorkflowDrawer
                initialWorkflowSearch={{ folderId: folder.id, searchInput: DEFAULT_APPLICATION_SEARCH }}
                isOpen={createApplicationView}
                onClose={() => setCreateApplicationView(false)}
            />
        </DotThemeProvider>
    );

    const renderView = () => {
        return isWizardView ? <BasicDiscovery closeWizard={() => setIsWizardView(false)} folder={folder} /> : renderData();
    };

    return loading || !folder ? <></> : renderView();
};
