import { applicationManagement, initialState } from './managed-application.reducer';
import { APPLICATION_MANAGEMENT_SLICE_NAME } from '../constants';

describe('managed application reducer', () => {
    const { getFilters, loadManagedApplications, setIsLoading, setManagedApplications, setManagedApplicationsCount, setPage, storeFilters } =
        applicationManagement.actions;

    it('should have the initial state', () => {
        expect(applicationManagement.name).toBe(APPLICATION_MANAGEMENT_SLICE_NAME);
        expect(applicationManagement.reducer(undefined, { type: 'default' })).toBe(initialState);
        expect(Object.keys(applicationManagement.actions)).toStrictEqual([
            'setPage',
            'loadManagedApplications',
            'setIsLoading',
            'setManagedApplications',
            'setManagedApplicationsCount',
            'storeFilters',
            'getFilters',
        ]);
    });

    describe('reducers', () => {
        describe('setPage', () => {
            it('should update state', () => {
                const state = applicationManagement.reducer(initialState, setPage('page' as never));
                expect(state.page).toStrictEqual('page');
            });
        });
        describe('loadManagedApplications', () => {
            it('should not update state', () => {
                const state = applicationManagement.reducer(initialState, loadManagedApplications());
                expect(state).toStrictEqual(initialState);
            });
        });
        describe('setIsLoading', () => {
            it('should update state', () => {
                const state = applicationManagement.reducer(initialState, setIsLoading(true));
                expect(state.isLoading).toBe(true);
            });
        });
        describe('setManagedApplications', () => {
            it('should update state', () => {
                const state = applicationManagement.reducer(initialState, setManagedApplications([1] as never));
                expect(state.managedApplications).toStrictEqual([1]);
            });
        });
        describe('setManagedApplicationsCount', () => {
            it('should update state', () => {
                const state = applicationManagement.reducer(initialState, setManagedApplicationsCount(2));
                expect(state.count).toBe(2);
            });
        });
        describe('storeFilters', () => {
            it('should not update state', () => {
                const state = applicationManagement.reducer(initialState, storeFilters());
                expect(state).toStrictEqual(initialState);
            });
        });
        describe('getFilters', () => {
            it('should update state', () => {
                const state = applicationManagement.reducer(initialState, getFilters('folderId'));
                expect(state.page.folderId).toBe('folderId');
            });
        });
    });
});
