import { ManagedApplicationsPage } from './managed-application.types';

export const APPLICATION_MANAGEMENT_SLICE_NAME = 'applicationManagement';
export const COLUMN_WIDTH = '12.50%';
export const COLUMN_APPLICATION_NAME = 'applicationName';
export const COLUMN_MANAGED_BY = 'managedBy';
export const COLUMN_DATE_CREATED = 'dateCreated';
export const COLUMN_TARGET_DEPLOYMENT = 'targetDeployment';
export const COLUMN_ENV_TAG = 'environmentTag';
export const COLUMN_TARGET_CONNECTION = 'targetConnection';
export const COLUMN_DEEP_LINK = 'deepLink';
export const COLUMN_ACTIONS = 'actions';

const DEFAULT_PAGE_ORDER = 'asc';
const DEFAULT_PAGE_INDEX = 0;
const DEFAULT_RESULTS_PER_PAGE = 10;
const DEFAULT_FOLDER_ID = undefined;

export const DEFAULT_MANAGED_APPLICATIONS_PAGE: ManagedApplicationsPage = {
    order: DEFAULT_PAGE_ORDER,
    page: DEFAULT_PAGE_INDEX,
    resultsPerPage: DEFAULT_RESULTS_PER_PAGE,
    folderId: DEFAULT_FOLDER_ID,
    orderBy: COLUMN_APPLICATION_NAME,
};

export const DEFAULT_APPLICATION_SEARCH = 'Application onboarding';
