import React from 'react';
import { DEFAULT_APPLICATION_SEARCH } from '../../constants';
import { ApplicationManagementState, initialState } from '../../ducks/managed-application.reducer';
import { mountWithStoreAndTheme, ReactWrapper } from '../../../../../../../../../../core/xlr-ui/tests/unit/testing-utils';
import { workflowStateMock } from '../../../../../../../../../../core/xlr-ui/app/features/workflow/mocks';
import { ApplicationsPageWrapper } from './applications-page-wrapper.component';
import { WorkflowDrawer } from '../../../../../../../../../../core/xlr-ui/app/features/workflow/workflow-drawer.component';
import { ApplicationsPageComponent } from '../applications-page/applications-page.component';

describe('ApplicationsPageWrapper', () => {
    let wrapper: ReactWrapper;
    const dispatch = jest.fn();

    const folder = { id: 'folderId', title: 'Folder' };

    const mountComponent = (state: ApplicationManagementState = initialState) => {
        wrapper = mountWithStoreAndTheme(<ApplicationsPageWrapper folder={folder} />, dispatch, {
            applicationManagement: state,
            workflow: workflowStateMock,
        });
    };
    const getWorkflowDrawer = () => wrapper.find(WorkflowDrawer);
    const openDrawer = () => wrapper.find(ApplicationsPageComponent).invoke('setCreateApplicationView')(true);

    it('should render WorkflowDrawer with correct props', () => {
        mountComponent();
        const workflowDrawer = getWorkflowDrawer();
        expect(workflowDrawer).toExist();
        const workflowDrawerProps = workflowDrawer.props();

        expect(workflowDrawerProps.initialWorkflowSearch).toEqual({
            folderId: 'folderId',
            searchInput: DEFAULT_APPLICATION_SEARCH,
        });
        expect(workflowDrawerProps.isOpen).toBe(false);
    });

    it('should open the drawer', () => {
        mountComponent();
        openDrawer();
        expect(getWorkflowDrawer().props().isOpen).toBe(true);
    });

    it('should close the drawer when onClose event gets triggered', () => {
        mountComponent();
        getWorkflowDrawer().invoke('onClose')();
        expect(getWorkflowDrawer().props().isOpen).toBe(false);
    });
});
