package com.xebialabs.xlrelease.status.sse

import com.xebialabs.xlrelease.status.sse.service.ServerSentEventsService
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Controller

import javax.ws.rs.core.{Context, MediaType}
import javax.ws.rs.sse.SseEventSink
import javax.ws.rs.{GET, Path, Produces}

@Path("/sse")
@Controller
@Produces(Array(MediaType.SERVER_SENT_EVENTS))
class ServerSentEventsResource @Autowired()(val serverSentEventsService: ServerSentEventsService) {

  @GET
  @Path("/application-status/register")
  def registerExternalDeploymentStream(@Context sseEventSink: SseEventSink): Unit = {
     serverSentEventsService.add(sseEventSink);
  }

}

