import { createSlice, PayloadAction } from '@reduxjs/toolkit';
import noop from 'lodash/noop';
import { RootState } from '../../../../../../../../../core/xlr-ui/app/js/store.types';
import { ServerCi } from '../external-deployment.types';

export interface TestConnectionStatus {
    errorText: string;
    success: boolean | undefined;
}
export interface ApplicationWizardState {
    connectionTested: boolean;
    testConnectionStatus: TestConnectionStatus;
}

export const initialState: ApplicationWizardState = {
    connectionTested: false,
    testConnectionStatus: {
        errorText: '',
        success: undefined,
    },
};

export const externalApplicationWizard = createSlice({
    name: 'externalApplicationWizard',
    initialState,
    reducers: {
        setConnectionTested: (state: ApplicationWizardState, action: PayloadAction<boolean>) => {
            state.connectionTested = action.payload;
        },
        setTestConnectionStatus: (state: ApplicationWizardState, action: PayloadAction<TestConnectionStatus>) => {
            state.testConnectionStatus = action.payload;
        },
        testConnection: (_state: ApplicationWizardState, _action: PayloadAction<ServerCi>) => noop(),
    },
});

export const getApplicationWizardState = (state: RootState): ApplicationWizardState => state.externalApplicationWizard;
