import React from 'react';
import { ReactWrapper } from 'enzyme';
import { Provider } from 'react-redux';
import { mountWithStoreAndTheme } from '../../../../../../../../../../core/xlr-ui/tests/unit/testing-utils';
import { ManagedApplication } from './managed-application.component';
import { ManagedApplicationType } from '../../managed-application.types';

describe('ManagedApplication component', () => {
    let wrapper: ReactWrapper;
    const dispatch = jest.fn();
    const defaultProps: ManagedApplicationType = {
        applicationName: 'Mario Deluxe',
        applicationReference: 'Argo CD',
        connectionServer: {
            id: 'Configuration/Custom/Configurationb128a7f883814423bd8badda97cbd816',
            name: 'Bruno test',
            type: 'argocd.ArgoCD',
            url: 'www.google.hr',
        },
        dateCreated: new Date(),
        environmentTag: 'DEV',
        id: '',
        managedBy: 'Release',
    };
    const mountComponent = () => {
        wrapper = mountWithStoreAndTheme(<ManagedApplication {...defaultProps} />, dispatch, {});
    };
    beforeEach(() => {
        mountComponent();
    });

    afterEach(() => {
        wrapper.unmount();
    });

    it('should render properly', () => {
        expect(wrapper.find(Provider)).toExist();
        expect(wrapper.find(ManagedApplication)).toExist();
    });
});
