import React from 'react';
import { Provider } from 'react-redux';
import { ShallowWrapper, shallow } from 'enzyme';
import { FolderApplicationSourcePage } from './folder-application-sources-page';
import { ApplicationSource } from './application-source.component';

describe('Folder application sources page', () => {
    let wrapper: ShallowWrapper;
    const defaultProps = {
        folder: { id: 'folderId', title: 'Folder' },
    };

    afterEach(() => {
        wrapper.unmount();
    });

    it('should contain application source page wrapper with store and pass props to ApplicationSource component', () => {
        wrapper = shallow(<FolderApplicationSourcePage {...defaultProps} />);
        expect(wrapper.type()).toStrictEqual(Provider);
        expect(wrapper.prop('store')).toBeTruthy();
        expect(wrapper.children()).toHaveLength(1);
        expect(wrapper.childAt(0).type()).toStrictEqual(ApplicationSource);
        expect(wrapper.childAt(0).prop('folder')).toStrictEqual(defaultProps.folder);
    });
});
