package com.xebialabs.xlrelease.status.webhook.events

import com.xebialabs.deployit.plugin.api.udm.{Metadata, Property}
import com.xebialabs.xlplatform.webhooks.events.domain.Event

import scala.beans.BeanProperty

@Metadata(virtual = false, label = "Status Webhook Request Event")
class StatusWebhookEvent extends Event {

  @BeanProperty
  @Property(label = "Operation")
  var operation: String = _

  @BeanProperty
  @Property(label = "Application Name")
  var applicationName: String = _

  @BeanProperty
  @Property(label = "Application UID")
  var applicationUid: String = _

  @BeanProperty
  @Property(label = "Application Path")
  var applicationPath: String = _

  @BeanProperty
  @Property(label = "Filtering value")
  var filteringValue: String = _

  @BeanProperty
  @Property(label = "Version label")
  var versionLabel: String = _

  @BeanProperty
  @Property(label = "Version state")
  var versionState: String = _

  @BeanProperty
  @Property(label = "Destination")
  var destination: String = _

  @BeanProperty
  @Property(label = "Destination UID")
  var destinationUid: String = _

  @BeanProperty
  @Property(label = "Namespace")
  var namespace: String = _


  @BeanProperty
  @Property(label = "Status group")
  var statusGroup: String = _

  @BeanProperty
  @Property(label = "Source endpoint", required = true, nested = true)
  var deploymentMetadata: WebhookStatusDeploymentMetadata = _

}
