import React from 'react';
import { DotActionToolbar, DotButton, DotCard, DotCardContent, DotCardHeader, DotDrawer, DotIconButton } from '@digital-ai/dot-components';
import { Template } from '../../../managed-application.types';
import { navigation } from '../../../../../../../../../../../core/xlr-ui/app/features/main-navigation/ducks/navigation.reducer';
import { useAppDispatch } from '../../../../../../../../../../../core/xlr-ui/app/js/hooks';

const { navigateTo } = navigation.actions;

export interface CreateApplicationDrawerProps {
    onClose: () => void;
    open: boolean;
    templates: Array<Template>;
}

export const CreateApplicationDrawer = ({ onClose, open, templates }: CreateApplicationDrawerProps) => {
    const dispatch = useAppDispatch();

    return (
        <DotDrawer
            PaperProps={{ style: { position: 'absolute' } }}
            anchor="bottom"
            className="folder-validation-modal"
            height="100%"
            open={open}
            variant="persistent"
            width="100%"
        >
            <DotActionToolbar>
                <div className="top-toolbar-icons">
                    <DotIconButton color="default" iconId="close" iconSize="small" onClick={onClose} size="medium" tooltip="Close" />
                </div>
            </DotActionToolbar>
            <h1>Choose Application Creation Workflows</h1>
            <div data-test-id="cards">
                <h2 style={{ textAlign: 'left', paddingLeft: '25px' }}>Application Creation workflows</h2>
                <div style={{ display: 'flex' }}>
                    {templates &&
                        templates.map((template: Template) => {
                            return (
                                <DotCard className="applications-workflow-card" key={template.id}>
                                    <DotCardHeader title={template.title} titleSize="medium" />
                                    <DotCardContent>{template.description}</DotCardContent>
                                    <DotButton
                                        onClick={() =>
                                            dispatch(
                                                navigateTo({
                                                    pathSuffix: `releases/create?fromTemplateId=${template.id}&stepperTitle=${template.title}&goToStepper=true`,
                                                }),
                                            )
                                        }
                                        type="outlined"
                                    >
                                        Run workflow
                                    </DotButton>
                                </DotCard>
                            );
                        })}
                    {templates.length === 0 && <p className="alert notice">No templates are tagged for Application pipeline.</p>}
                </div>
            </div>
        </DotDrawer>
    );
};
