import { Order, RowsPerPageOption } from '@digital-ai/dot-components';

export interface Template {
    description: string;
    id: string;
    title: string;
}

export interface TemplateFilter {
    parentId: string;
}

export interface ManagedApplicationType {
    applicationName: string;
    applicationReference: string;
    connectionServer: {
        id: string;
        name: string;
        type: string;
        url: string;
    };
    dateCreated: Date;
    environmentTag: string;
    id: string;
    managedBy: 'Release' | 'View-only';
}

export interface ManagedApplicationsPage {
    folderId?: string;
    order: Order;
    orderBy: string;
    page: number;
    resultsPerPage: RowsPerPageOption;
}

export interface FetchTemplatesResponse {
    cis: Array<Template>;
}

export interface DevOpsDeploymentsFeatureResponse {
    applicationPipelineTag: string;
    enabled: boolean;
}
