import {applicationManagement, initialState} from './managed-application.reducer';
import {APPLICATION_MANAGEMENT_SLICE_NAME} from "../constants";

describe('managed application reducer', () => {
    const { setTemplates, fetchTemplates } = applicationManagement.actions;

    it('should have the initial state', () => {
        expect(applicationManagement.name).toBe(APPLICATION_MANAGEMENT_SLICE_NAME);
        expect(applicationManagement.reducer(undefined, { type: 'default' })).toBe(initialState);
    });

    describe('reducers', () => {
        describe('setTemplates', () => {
            it('should set templates', () => {
                const template = { id: 'template-1', title: 'title-1', description: 'description-1' };
                const state = applicationManagement.reducer(initialState, setTemplates([template]));
                expect(state.templates.length).toBe(1);
                expect(state.templates).toStrictEqual([template]);
                expect(state.templates).toContain(template);
            });
        });
        describe('fetchTemplates', () => {
            it('should fetch templates', () => {
                const state = applicationManagement.reducer(initialState, fetchTemplates({ parentId: 'folder-1' }));
                expect(state).toStrictEqual(initialState);
            });
        });
    });
});
