import React from 'react';
import { ReactWrapper } from 'enzyme';
import { Provider } from 'react-redux';
import { mountComponentWithStore } from '../../../../../../../../../../core/xlr-ui/tests/unit/testing-utils';
import { ManagedApplication } from './managed-application.component';
import { ManagedApplicationType } from '../../managed-application.types';

describe('ManagedApplication component', () => {
    let wrapper: ReactWrapper;
    const defaultProps: ManagedApplicationType = {
        applicationName: 'Mario Deluxe',
        managedBy: 'Release',
        dateCreated: new Date(),
        environmentTag: 'DEV',
        id: '',
        applicationReference: 'Argo CD',
        connectionServer: {
            id: 'Configuration/Custom/Configurationb128a7f883814423bd8badda97cbd816',
            name: 'Bruno test',
            type: 'argocd.ArgoCD',
            url: 'www.google.hr',
        },
    };
    const mountComponent = () => {
        wrapper = mountComponentWithStore(<ManagedApplication {...defaultProps} />);
    };
    beforeEach(() => {
        mountComponent();
    });

    afterEach(() => {
        wrapper.unmount();
    });

    it('should render properly', () => {
        expect(wrapper.find(Provider)).toExist();
        expect(wrapper.find(ManagedApplication)).toExist();
    });
});
