import React from 'react';
import { ReactWrapper } from 'enzyme';
import { mountWithStoreAndTheme } from '../../../../../../../../../../../core/xlr-ui/tests/unit/testing-utils';
import { CreateApplicationDrawer } from './create-application-drawer';
import { DotActionToolbar, DotCard, DotCardHeader, DotCardContent, DotButton, DotIconButton } from '@digital-ai/dot-components';
import { navigation } from '../../../../../../../../../../../core/xlr-ui/app/features/main-navigation/ducks/navigation.reducer';

const { navigateTo } = navigation.actions;
const dispatch = jest.fn();
const onClose = jest.fn();
describe('CreateApplicationDrawer component', () => {
    let wrapper: ReactWrapper;
    const mountComponent = () => {
        const defaultProps = {
            open: true,
            onClose,
            templates: [{ id: 'template-1', title: 'title-1', description: 'description-1' }],
        };
        wrapper = mountWithStoreAndTheme(<CreateApplicationDrawer {...defaultProps} />, dispatch);
    };

    beforeEach(() => {
        mountComponent();
    });

    afterEach(() => {
        wrapper.unmount();
    });

    it('should render drawer properly', () => {
        const templatesDrawer = wrapper.find(CreateApplicationDrawer);
        expect(templatesDrawer.props().onClose).toBe(onClose);
        expect(templatesDrawer.props().templates.length).toBe(1);
        expect(templatesDrawer.props().open).toBe(true);
        expect(templatesDrawer.find(`h1`).text()).toBe('Choose Application Creation Workflows');
    });

    it('should contain button close', () => {
        const actionToolbar = wrapper.find(DotActionToolbar);
        expect(actionToolbar.find(DotIconButton)).toExist();
        expect(actionToolbar.find(DotIconButton).props().onClick).toBe(onClose);
    });

    it('should contain dot card with template', () => {
        const cardsDiv = wrapper.find(`div[data-test-id="cards"]`);
        expect(cardsDiv).toExist();
        expect(cardsDiv.find(DotCard)).toHaveLength(1);
        expect(cardsDiv.find(DotCard).at(0).find(DotCardHeader).props().title).toBe('title-1');
        expect(cardsDiv.find(DotCard).at(0).find(DotCardContent).text()).toContain('description-1');
    });

    it('should find DotButton in the template card', () => {
        const cardsDiv = wrapper.find(`div[data-test-id="cards"]`);
        cardsDiv.find(DotButton).at(0).invoke('onClick')?.('' as never);
        expect(dispatch).toHaveBeenCalledWith(navigateTo({ pathSuffix: `releases/create?fromTemplateId=template-1&stepperTitle=title-1&goToStepper=true` }));
    });
});
