import React from 'react';
import { ReactWrapper } from 'enzyme';
import noop from 'lodash/noop';
import { mountComponentWithStore } from '../../../../../../../../../../core/xlr-ui/tests/unit/testing-utils';
import { ApplicationsPageComponent } from './applications-page.component';
import { ApplicationManagementState, initialState } from '../../ducks/managed-application.reducer';

const dispatch = jest.fn();
describe('ExternalDeployment component', () => {
    let wrapper: ReactWrapper;
    const defaultProps = {
        folder: { id: 'folderId', title: 'Folder' },
        onViewChange: noop,
    };
    const mountComponent = (state: ApplicationManagementState = initialState) => {
        wrapper = mountComponentWithStore(<ApplicationsPageComponent {...defaultProps} />, dispatch, { applicationManagement: state });
    };
    beforeEach(() => {
        mountComponent();
    });

    afterEach(() => {
        wrapper.unmount();
    });
    const searchDotCard = (selector: string) => wrapper.find(`.applications-placeholder ${selector}`);

    it('should show the title and description', () => {
        expect(searchDotCard('.applications-title').text()).toStrictEqual('Applications');
        expect(searchDotCard('.applications-description').text()).toContain(
            'Getting started with your applications. Create new applications in Argo CD or Digital.ai Deploy.',
        );
    });

    it('should show the discover and create buttons', () => {
        expect(searchDotCard('.applications-buttons button').at(0).text()).toStrictEqual('Discover applications');
        expect(searchDotCard('.applications-buttons button').at(1).text()).toStrictEqual('Create application');
    });
});
