import { SagaIterator } from 'redux-saga';
import { all, call, put, takeEvery, takeLatest } from 'redux-saga/effects';
import { applicationManagement } from './managed-application.reducer';
import {
    managedApplicationSaga,
    executeFetchManagedApplicationsAction,
    executeFetchTemplatesAction,
    getFiltersAction,
    storeFiltersAction,
} from './managed-application.saga';
import { httpGET, httpPOST } from '../../../../../../../../../core/xlr-ui/app/features/common/services/http';

const { fetchTemplates, getFilters, loadManagedApplications, setTemplates, storeFilters } = applicationManagement.actions;

describe('applicationManagementSaga', () => {
    it('should yield all effects', () => {
        const gen: SagaIterator = managedApplicationSaga();
        expect(gen.next().value).toStrictEqual(
            all([
                takeLatest(fetchTemplates, executeFetchTemplatesAction),
                takeLatest(loadManagedApplications, executeFetchManagedApplicationsAction),
                takeEvery(storeFilters, storeFiltersAction),
                takeEvery(getFilters, getFiltersAction),
            ]),
        );
        expect(gen.next().done).toBe(true);
    });

    describe('executeFetchTemplatesAction', () => {
        const cis = [{ id: 'template-1', title: 'title-1', description: 'description-1' }];
        const applicationPipelineTag = 'the-tag';
        it('should call fetchTemplatesAction', () => {
            const filter = { parentId: 'folder-1', tags: [applicationPipelineTag] };
            const gen: SagaIterator = executeFetchTemplatesAction({
                payload: filter,
                type: 'whatever',
            });
            expect(gen.next().value).toStrictEqual(call(httpGET, `/settings/features/xlrelease.DevOpsDeploymentsFeature`));
            expect(gen.next({ data: { applicationPipelineTag } }).value).toStrictEqual(call(httpPOST, `releases/templates/search`, filter));
            expect(gen.next({ data: { cis } }).value).toStrictEqual(put(setTemplates(cis)));
            expect(gen.next().done).toBeTruthy();
        });
    });
});
