import React from 'react';
import { ReactWrapper } from 'enzyme';
import { Provider } from 'react-redux';
import { mountComponentWithStore } from '../../../../../../../../../core/xlr-ui/tests/unit/testing-utils';
import { FolderApplicationsManagementPage } from './folder-applications-management';
import { ApplicationsPageComponent } from './applications-page/applications-page.component';

describe('FolderApplicationsManagementPage component', () => {
    let wrapper: ReactWrapper;
    const defaultProps = {
        folder: { id: 'folderId', title: 'Folder' },
    };
    const mountComponent = () => {
        wrapper = mountComponentWithStore(<FolderApplicationsManagementPage {...defaultProps} />);
    };
    beforeEach(() => {
        mountComponent();
    });

    afterEach(() => {
        wrapper.unmount();
    });

    it('should render properly', () => {
        expect(wrapper.find(Provider)).toExist();
        expect(wrapper.find(ApplicationsPageComponent)).toExist();
    });
});
