import React from 'react';
import { ReactWrapper } from 'enzyme';
import { Provider } from 'react-redux';
import { mountComponentWithStore } from '../../../../../../../../../../core/xlr-ui/tests/unit/testing-utils';
import { ManagedApplicationTable, ManagedApplicationTableProps } from './managed-application-table.component';

describe('ManagedApplicationTable component', () => {
    let wrapper: ReactWrapper;
    const defaultProps: ManagedApplicationTableProps = {
        folder: { id: 'folderId', title: 'Folder' },
        onViewChange: () => {},
    };
    const mountComponent = () => {
        wrapper = mountComponentWithStore(<ManagedApplicationTable {...defaultProps} />);
    };
    beforeEach(() => {
        mountComponent();
    });

    afterEach(() => {
        wrapper.unmount();
    });

    it('should render properly', () => {
        expect(wrapper.find(Provider)).toExist();
        expect(wrapper.find(ManagedApplicationTable)).toExist();
    });
});
