import React, { MouseEvent, useState } from 'react';
import { DotButton, DotIconButton, DotMenu } from '@digital-ai/dot-components';
import { ActionToolbarPortalContainer } from '../../../../../../../../../../core/xlr-ui/app/features/main-navigation/action-toolbar/components/action-toolbar.portal';
import { Folder } from '../../../../../../../../../../core/xlr-ui/app/types';

export interface ManagedApplicationTableComponentPortalProps {
    folder: Folder;
    onViewChange: () => void;
}

export const ManagedApplicationTableComponentPortal = ({ onViewChange }: ManagedApplicationTableComponentPortalProps) => {
    const [isMenuOpen, setIsMenuOpen] = useState<boolean>(false);
    const [menuAnchorEl, setMenuAnchorEl] = useState<HTMLElement | null>(null);

    const toggleMenu = (event: MouseEvent<HTMLElement>) => {
        setMenuAnchorEl(event.currentTarget);
        setIsMenuOpen(!isMenuOpen);
    };

    return (
        <ActionToolbarPortalContainer>
            <DotButton onClick={() => onViewChange()}>Discover applications</DotButton>
            <>
                <DotIconButton data-testid="application-deployments-menu" iconId="options" onClick={toggleMenu} />
                <DotMenu
                    anchorEl={menuAnchorEl || undefined}
                    dense
                    id="application-deployments-option"
                    menuPlacement="bottom"
                    onLeave={() => setIsMenuOpen(false)}
                    onSelect={() => setIsMenuOpen(false)}
                    open={isMenuOpen}
                    menuItems={[
                        {
                            key: 'placeholder',
                            children: 'Placeholder',
                        },
                    ]}
                />
            </>
        </ActionToolbarPortalContainer>
    );
};
