import React, { useEffect, useState } from 'react';
import { FolderExternalDeploymentsProps } from '../../../external-deployments/components/folder-external-deployments';
import { ManagedApplicationTable } from './managed-application-table.component';
import { ApplicationsPageComponent } from '../applications-page/applications-page.component';
import { useAppDispatch, useAppSelector } from '../../../../../../../../../../core/xlr-ui/app/js/hooks';
import { getCreatedApplicationsCountSelector, getCreatedApplicationsLoadingSelector } from '../../ducks/managed-application.selectors';
import { applicationManagement } from '../../ducks/managed-application.reducer';
import { BasicDiscovery } from '../../../external-deployments/components/wizard/basic-wizard/application-discovery-basic.component';

const { loadManagedApplications, getFilters } = applicationManagement.actions;

export const ApplicationsPageWrapper = ({ folder }: FolderExternalDeploymentsProps) => {
    const dispatch = useAppDispatch();

    useEffect(() => {
        dispatch(getFilters(folder.id));
        dispatch(loadManagedApplications());
    }, []);

    const [isWizardView, setIsWizardView] = useState(false);
    const loading = useAppSelector(getCreatedApplicationsLoadingSelector);
    const dataSize = useAppSelector(getCreatedApplicationsCountSelector);
    const hasAnyData = dataSize > 0;
    return loading ? (
        <></>
    ) : isWizardView ? (
        <BasicDiscovery closeWizard={() => setIsWizardView(false)} folder={folder} />
    ) : hasAnyData ? (
        <ManagedApplicationTable onViewChange={() => setIsWizardView(true)} folder={folder} />
    ) : (
        <ApplicationsPageComponent onViewChange={() => setIsWizardView(true)} folder={folder} />
    );
};
