package com.xebialabs.xlrelease.api.internal

import com.xebialabs.xlrelease.api.v1.ManagedApplicationApi
import com.xebialabs.xlrelease.api.v1.forms.ManagedApplicationForm
import com.xebialabs.xlrelease.api.v1.views.{ManagedApplicationPage, ManagedApplicationView}
import com.xebialabs.xlrelease.applications.management.service.ApplicationsManagementService
import org.springframework.stereotype.Controller

import java.lang

@Controller
class ManagedApplicationApiImpl(
                                    applicationsManagementService: ApplicationsManagementService
                                   ) extends ManagedApplicationApi{

  override def getManagedApplications(folderId: String, page: lang.Long, resultsPerPage: lang.Long): ManagedApplicationPage =
    applicationsManagementService.getManagedApplications(folderId, page, resultsPerPage)

  override def deleteManagedApplication(managedApplicationId: String): Unit =
    applicationsManagementService.deleteManagedApplication(managedApplicationId)

  override def addManagedApplication(managedApplicationForm: ManagedApplicationForm): ManagedApplicationView =
    applicationsManagementService.addManagedApplication(managedApplicationForm)

  override def updateManagedApplication(managedApplicationForm: ManagedApplicationForm): ManagedApplicationView =
    applicationsManagementService.updateManagedApplication(managedApplicationForm)
}
