import React from 'react';
import { mountWithStoreAndTheme, ReactWrapper } from '@xlr-ui/tests/unit/testing-utils';
import { MicrostrategyDashboard } from './microstrategy-dashboard.component';
import { navigation } from '@xlr-ui/app/features/main-navigation/ducks/navigation.reducer';

const { setMenuOpen } = navigation.actions;

describe('MicrostrategyDashboard', () => {
    const dispatch = jest.fn();
    const defaultState = {
        navigation: {
            menuIsOpen: true,
        },
        analytics: {},
    };

    let wrapper: ReactWrapper;

    const mount = (state = defaultState) => {
        wrapper = mountWithStoreAndTheme(<MicrostrategyDashboard embedConfig={{} as never} serverUrl={'url'} />, dispatch, state);
    };

    it('should dispatch actions on init', () => {
        mount();
        expect(dispatch).toHaveBeenCalledWith(setMenuOpen(false));
    });

    it('should reopen the sidebar if it was open', () => {
        mount();
        dispatch.mockReset();
        wrapper.unmount();
        expect(dispatch).toHaveBeenCalledWith(setMenuOpen(true));
    });

    it('should not reopen the sidebar if it was closed', () => {
        mount({ ...defaultState, navigation: { menuIsOpen: false } });
        dispatch.mockReset();
        wrapper.unmount();
        expect(dispatch).not.toHaveBeenCalledWith(setMenuOpen(true));
    });
});
