import React from 'react';
import { DotIconButton, DotProgress } from '@digital-ai/dot-components';
import { getFavoriteIcon, getFavoriteText } from '../../helpers';
import { NOT_CONFIGURED_TOOLTIP } from '../analytics-card.component';
import './analytics-favorite-icon-button.component.less';

export interface AnalyticsFavoriteIconButtonProps {
    isAnalyticsConfigured: boolean;
    isFavorite: boolean;
    isUpdating: boolean;
    onFavoriteClick: () => void;
}

export const AnalyticsFavoriteIconButton = ({ isAnalyticsConfigured, isFavorite, isUpdating, onFavoriteClick }: AnalyticsFavoriteIconButtonProps) => {
    return (
        <div className="analytics-favorite">
            {isUpdating ? (
                <DotProgress ariaLabel="Updating dashboard" className="analytics-favorite-progress" size={20} tooltip="Updating dashboard" />
            ) : (
                <DotIconButton
                    disabled={!isAnalyticsConfigured}
                    iconId={getFavoriteIcon(isFavorite)}
                    onClick={onFavoriteClick}
                    tooltip={isAnalyticsConfigured ? getFavoriteText(isFavorite) : NOT_CONFIGURED_TOOLTIP}
                />
            )}
        </div>
    );
};
