import React from 'react';
import { CssCell, CssGrid, DotCard, DotCardContent, DotCardFooter, DotSkeleton } from '@digital-ai/dot-components';
import { calculateCellProps } from '@xlr-ui/app/features/workflow/helper';

export const AnalyticsCardsSkeleton = () => {
    const renderCardSkeleton = () => {
        return (
            <DotCard className="analytics-card">
                <DotCardContent className="card-content">
                    <DotSkeleton height="20px" variant="text" width="100%" />
                    <DotSkeleton height="100px" variant="rectangular" width="100%" />
                    <DotSkeleton height="20px" variant="text" width="100%" />
                    <DotSkeleton height="20px" variant="text" width="100%" />
                </DotCardContent>
                <DotCardFooter>
                    <DotSkeleton height="40px" variant="rectangular" width="100px" />
                </DotCardFooter>
            </DotCard>
        );
    };

    const renderCards = () => {
        return (
            <CssGrid className="css-grid">
                {[0, 1, 2, 3, 4, 5].map((_i, index) => {
                    return (
                        <CssCell {...calculateCellProps(index)} key={index}>
                            {renderCardSkeleton()}
                        </CssCell>
                    );
                })}
            </CssGrid>
        );
    };

    return <div className="analytics-cards">{renderCards()}</div>;
};
