global configurationApi
global request, response

from intelligence import AnalyticsServer
import java.util as util

def isList(value):
    return isinstance(value, list) or isinstance(value, util.List)

access_token = request.entity['accessToken']
server_id = request.query['serverId']
page = int(request.query['page'])
count = int(request.query['resultsPerPage'])
favorite = bool(request.query.get('favorite', 0))
filter_string = request.query.get('filter', None)

filters = None

if not isList(filter_string) and filter_string is not None:
    filters = filter_string.split("&")
elif not None:
    filters = filter_string

server = configurationApi.getConfiguration(server_id)

analytics_server = AnalyticsServer(server, access_token)

start = page * count

response.entity = analytics_server.list_embeddable_dashboards(start, count, filters, favorite)
