import React from 'react';
import { DotButton, DotCard, DotCardContent, DotCardFooter, DotCardHeader, DotTypography } from '@digital-ai/dot-components';
import { ChipGroup } from '../../../../../../../../../core/xlr-ui/app/react/components/chip-group/chip-group.component';
import { AnalyticsCardData } from '../types';
import { DIGITAL_AI_AUTHOR } from '../constants';
import { AnalyticsFavoriteIconButton } from './dashboard/analytics-favorite-icon-button.component';
import './analytics-card.component.less';

export interface AnalyticsCardProps extends AnalyticsCardData {
    isAnalyticsConfigured: boolean;
    isFavorite: boolean;
    isUpdating: boolean;
    onFavoriteClick: () => void;
    onOpenDashboardClick: () => void;
}

export const NOT_CONFIGURED_TOOLTIP = 'To use this functionality, please configure Digital.ai Analytics connection first.';

export const AnalyticsCard = ({
    contentText,
    id,
    imageSrc,
    isAnalyticsConfigured,
    isFavorite,
    isUpdating,
    onFavoriteClick,
    onOpenDashboardClick,
    subtitle,
    tags,
    title,
}: AnalyticsCardProps) => {
    const getCardImage = () => {
        if (!imageSrc) return 'static/@project.version@/include/analytics-dashboard/assets/custom.svg';
        else if (isAnalyticsConfigured) return `data:image/svg+xml;base64,${imageSrc}`;
        else return imageSrc;
    };

    return (
        <DotCard className="analytics-card" key={id}>
            <DotCardHeader
                action={
                    <AnalyticsFavoriteIconButton
                        isAnalyticsConfigured={isAnalyticsConfigured}
                        isFavorite={isFavorite}
                        isUpdating={isUpdating}
                        onFavoriteClick={onFavoriteClick}
                    />
                }
                className="card-header"
                subheader={`by ${subtitle || DIGITAL_AI_AUTHOR}`}
                title={title}
                titleSize="medium"
            />
            <img alt="Analytics card image" src={getCardImage()} />
            <DotCardContent className="card-content">
                <DotTypography className="card-content-description" data-testid="content-typography" variant="body1">
                    {contentText}
                </DotTypography>
                <ChipGroup labels={tags} />
            </DotCardContent>
            <DotCardFooter>
                <DotButton
                    className="open-dashboard-btn"
                    data-testid={isAnalyticsConfigured ? '' : 'open-analytics-dashboard-btn'}
                    onClick={onOpenDashboardClick}
                    type="outlined"
                >
                    Open dashboard
                </DotButton>
            </DotCardFooter>
        </DotCard>
    );
};
