import React, { FC, useEffect } from 'react';
import { DotCoreApiProvider, DotMetadataApiProvider } from '@digital-ai/dot-components';
import { useAppDispatch, useAppSelector } from '../../../../../../../../../../core/xlr-ui/app/js/hooks';
import { analytics, getAnalyticsState } from '../../ducks/analytics.reducer';

const { refreshToken } = analytics.actions;

export const EVERY_MINUTE = 60_000;

export const AnalyticsAuthProvider: FC = ({ children }) => {
    const { tokenValue, intelligenceConfiguration } = useAppSelector(getAnalyticsState);
    const dispatch = useAppDispatch();

    useEffect(() => {
        // eslint-disable-next-line angular/interval-service
        const refreshTokenScheduler = setInterval(() => {
            dispatch(refreshToken());
        }, EVERY_MINUTE);
        return () => {
            clearInterval(refreshTokenScheduler);
        };
    }, []);

    if (!intelligenceConfiguration) {
        return <>{children}</>;
    }

    return (
        <DotCoreApiProvider apiUrl={intelligenceConfiguration.url} token={tokenValue}>
            <DotMetadataApiProvider apiUrl={intelligenceConfiguration.url} token={tokenValue}>
                {children}
            </DotMetadataApiProvider>
        </DotCoreApiProvider>
    );
};
