global configurationApi
global request, response

from intelligence import AnalyticsServer

server_id = request.query['serverId']
access_token = request.entity['accessToken']
dashboard_id = request.query['dashboardId']
unfavorite = bool(request.query.get('unfavorite', 0))

server = configurationApi.getConfiguration(server_id)

analytics_server = AnalyticsServer(server, access_token)

if unfavorite:
    response.entity = analytics_server.unfavorite_dashboard(dashboard_id)
else:
    response.entity = analytics_server.favorite_dashboard(dashboard_id)
