import { SagaIterator } from 'redux-saga';
import { put, call, select, delay } from 'redux-saga/effects';
import { AnalyticsSidebarProvider, getSelectedDashboard } from './analytics-sidebar-provider';
import { navigation } from '../../../../../../../../../../core/xlr-ui/app/features/main-navigation/ducks/navigation.reducer';
import { getAnalyticsStateDashboard } from '../../ducks/analytics.reducer';

const { setBackItem, updateBreadcrumbs, setSidebarMenu, setLastBreadcrumb } = navigation.actions;

describe('AnalyticsSidebarProvider', () => {
    const provider = new AnalyticsSidebarProvider();

    describe('getSelectedDashboard', () => {
        it('should loop if no dashboard is selected', () => {
            const gen = getSelectedDashboard();
            expect(gen.next().value).toMatchObject(select(getAnalyticsStateDashboard));
            expect(gen.next(undefined as never).value).toMatchObject(delay(1000));
            expect(gen.next().value).toMatchObject(call(getSelectedDashboard));
            expect(gen.next().done).toBe(true);
        });
        it('should end saga is dashboard is selected', () => {
            const selectedDashboard = {
                title: 'Dora the explorer',
            };
            const gen = getSelectedDashboard();
            expect(gen.next().value).toMatchObject(select(getAnalyticsStateDashboard));
            expect(gen.next(selectedDashboard as never)).toMatchObject({ done: true, value: selectedDashboard });
        });
    });

    describe('isSupported', () => {
        it('should be false for /analytics path', () => {
            expect(provider.isSupported('/analytics')).toBe(false);
        });

        it('should be true for paths inside /analytics', () => {
            expect(provider.isSupported('/analytics/1')).toBe(true);
        });
    });

    describe('provide', () => {
        it('should call proper sagas', () => {
            const generator: SagaIterator = provider.provide('ignored');
            expect(generator.next().value).toStrictEqual(call(getSelectedDashboard));
            expect(generator.next({ title: 'my analytics dashboard title' }).value).toStrictEqual(put(setLastBreadcrumb(undefined)));
            expect(generator.next().value).toStrictEqual(
                put(
                    updateBreadcrumbs([
                        {
                            href: '/analytics',
                            text: 'Analytics',
                        },
                        {
                            text: 'my analytics dashboard title',
                        },
                    ]),
                ),
            );
            expect(generator.next().value).toStrictEqual(put(setSidebarMenu({ sidebarMenu: [], withFolder: false })));
            expect(generator.next().value).toStrictEqual(
                put(
                    setBackItem({
                        pathSuffix: 'analytics',
                        title: 'Analytics',
                        text: 'Analytics',
                    }),
                ),
            );
            expect(generator.next().done).toBe(true);
        });
    });
});
