import React from 'react';
import { DotIconButton, DotProgress } from '@digital-ai/dot-components';
import { mountWithTheme, preparePortalContainer, ReactWrapper } from '../../../../../../../../../../core/xlr-ui/tests/unit/testing-utils';
import { AnalyticsFavoriteIconButton, AnalyticsFavoriteIconButtonProps } from './analytics-favorite-icon-button.component';
import { getFavoriteIcon, getFavoriteText } from '../../helpers';

describe('AnalyticsFavoriteIconButton', () => {
    let wrapper: ReactWrapper;
    const onFavoriteClick = jest.fn();
    const isFavorite = false;
    const isAnalyticsConfigured = true;
    const isUpdating = false;

    const defaultProps: AnalyticsFavoriteIconButtonProps = {
        isAnalyticsConfigured,
        isFavorite,
        isUpdating,
        onFavoriteClick,
    };

    const mount = (props = defaultProps) => {
        wrapper = mountWithTheme(<AnalyticsFavoriteIconButton {...props} />);
    };

    const getFavoriteIconButton = () => wrapper.findWhere((node) => node.is(DotIconButton));
    const getDotProgress = () => wrapper.find(DotProgress);

    beforeEach(() => {
        preparePortalContainer();
    });

    it('should render icon button', () => {
        mount();
        const favoriteIconButton = getFavoriteIconButton();
        expect(favoriteIconButton).toExist();
        const favoriteIconButtonProps = favoriteIconButton.props();
        expect(favoriteIconButtonProps.disabled).toBe(!isAnalyticsConfigured);
        expect(favoriteIconButtonProps.iconId).toBe(getFavoriteIcon(isFavorite));
        expect(favoriteIconButtonProps.onClick).toStrictEqual(expect.any(Function));
        expect(favoriteIconButtonProps.tooltip).toBe(getFavoriteText(isFavorite));
    });

    it('should render DotProgress component when isUpdating flag is set to true', () => {
        mount({ ...defaultProps, isUpdating: true });
        const dotProgress = getDotProgress();
        expect(dotProgress).toExist();
        const dotProgressProps = dotProgress.props();
        expect(dotProgressProps.ariaLabel).toBe('Updating dashboard');
        expect(dotProgressProps.className).toBe('analytics-favorite-progress');
        expect(dotProgressProps.size).toBe(20);
        expect(dotProgressProps.tooltip).toBe('Updating dashboard');
    });
});
