import React from 'react';
import { DotButton } from '@digital-ai/dot-components';
import { mountWithTheme, preparePortalContainer, ReactWrapper } from '../../../../../../../../../../core/xlr-ui/tests/unit/testing-utils';
import { AnalyticsDashboardPagePortal, AnalyticsDashboardPagePortalProps } from './analytics-dashboard-page.portal';
import { AnalyticsFavoriteIconButton } from './analytics-favorite-icon-button.component';

describe('AnalyticsDashboardPagePortal', () => {
    let wrapper: ReactWrapper;
    const onFavoriteClick = jest.fn();
    const isFavorite = false;
    const isUpdating = false;

    const defaultProps: AnalyticsDashboardPagePortalProps = {
        dashboardId: '1',
        folderId: undefined,
        isFavorite,
        isUpdating,
        onFavoriteClick,
    };

    const mount = (props = defaultProps) => {
        wrapper = mountWithTheme(<AnalyticsDashboardPagePortal {...props} />);
    };

    const getBackButton = () => wrapper.findWhere((node) => node.is(DotButton) && node.props()['data-testid'] === 'back-btn');
    const getAnalyticsFavoriteIconButton = () => wrapper.findWhere((node) => node.is(AnalyticsFavoriteIconButton));

    beforeEach(() => {
        preparePortalContainer();
    });

    it('should render all buttons', () => {
        mount();
        const backButton = getBackButton();
        expect(backButton).toExist();
        expect(backButton).toIncludeText('Back');
        expect(backButton.props().type).toBe('outlined');
        const favoriteButton = getAnalyticsFavoriteIconButton();
        expect(favoriteButton).toExist();
        const favoriteButtonProps = favoriteButton.props();
        expect(favoriteButtonProps.isAnalyticsConfigured).toBe(true);
        expect(favoriteButtonProps.isFavorite).toBe(isFavorite);
        expect(favoriteButtonProps.isUpdating).toBe(isUpdating);
        expect(favoriteButtonProps.onFavoriteClick).toStrictEqual(expect.any(Function));
    });

    it('should handle back button for global', () => {
        mount();
        getBackButton().invoke('onClick')();
        expect(window.location.href).toBe('http://localhost/#/analytics');
    });

    it('should handle back button for folder', () => {
        mount({ ...defaultProps, folderId: 'Applications/Folder1' });
        getBackButton().invoke('onClick')();
        expect(window.location.href).toBe('http://localhost/#/folders/Applications/Folder1/analytics');
    });

    it('should handle favorite button', () => {
        mount();
        const favoriteButton = getAnalyticsFavoriteIconButton();
        favoriteButton.invoke('onFavoriteClick')();
        expect(onFavoriteClick).toHaveBeenLastCalledWith();
    });
});
