import { ClientSettings, HttpConnection } from '../../../../../../../../../core/xlr-ui/app/types';
import { CardSearch } from '../ducks/analytics.reducer';
import { PropsForDashboard } from '../../../../../../../../../core/xlr-ui/app/features/custom-ui/window';

export interface AnalyticsCardData {
    contentText: string;
    embedConfig: EmbedConfig;
    embeddingId: string;
    externalId: number;
    folderFilter?: NativeFilterConfiguration;
    id: string;
    imageSrc: string;
    isFavorite: boolean;
    serverUrl: string;
    subtitle: string;
    tags: string[];
    title: string;
}

export interface IntelligenceHttpConnection extends HttpConnection {
    folderColumnName: string;
}

export interface AnalyticsClientSettings extends ClientSettings {
    setAnalyticsListFilters: (filter: CardSearch | undefined) => void;
}

export interface AccessTokenResponse {
    expiresAt: number;
    tokenValue: string;
}

export interface DashboardListResponse {
    entity: PlatformListDashboardWithPaginationResponse;
}

export interface DashboardGetResponse {
    entity: PlatformListDashboardResponse;
}

export interface PlatformAuthor {
    full_name: string;
    id: string;
}

export interface PlatformMetadataResponse {
    authors: PlatformAuthor[];
    categories: string[];
}

export interface DashboardMetadataResponse {
    entity: PlatformMetadataResponse;
}

export interface PlatformUserResponse {
    entity: PlatformUser;
}

export interface PlatformUser {
    account: PlatformAccount;
    account_id: string;
    id: string;
    roles: string[];
    username: string;
}

export interface PlatformAccount {
    vanity_domain: string;
}

type DashboardLifeCycleState = 'DRAFT' | 'PUBLISHED';

export interface NativeFilterConfigurationSource {
    id: string;
    type: number;
}

export interface NativeFilterConfiguration {
    key: string;
    name: string;
    source: NativeFilterConfigurationSource;
    summary: string;
}

export interface PlatformListDashboardWithPaginationResponse {
    pagination: PlatformListDashboardPagination;
    results: PlatformListDashboardResponse[];
}

export interface PlatformListDashboardPagination {
    count: number;
    next_start: number | null;
    previous_start: number | null;
    start: number;
    total_available: number;
}

export interface PlatformListDashboardResponse {
    author_fullname: string;
    categories: Array<string>;
    created_dt: string;
    description: string;
    embed_config: EmbedConfig;
    external_embedding_id: string;
    external_id: string;
    favorite: boolean;
    filter_configuration: Array<NativeFilterConfiguration>;
    id: string;
    is_ootb_dashboard: boolean;
    lifecycle_state: DashboardLifeCycleState;
    name: string;
    server_url: string;
    thumbnail: string;
}

export type EmbedConfig = Omit<PropsForDashboard, 'placeholder'>;
