import React from 'react';
import { DotButton, DotIcon } from '@digital-ai/dot-components';
import { ActionToolbarPortal } from '../../../../../../../../../../core/xlr-ui/app/features/main-navigation/action-toolbar/components/action-toolbar.portal';
import { AnalyticsFavoriteIconButton } from './analytics-favorite-icon-button.component';

export interface AnalyticsDashboardPagePortalProps {
    dashboardId: string;
    folderId?: string;
    isFavorite: boolean;
    isUpdating: boolean;
    onFavoriteClick: () => void;
}

export const AnalyticsDashboardPagePortal = ({
    dashboardId: _dashboardId,
    folderId,
    isFavorite,
    isUpdating,
    onFavoriteClick,
}: AnalyticsDashboardPagePortalProps) => {
    const handleBackClick = () => {
        if (folderId) {
            window.location.href = `#/folders/${folderId}/analytics`;
        } else {
            window.location.href = '#/analytics';
        }
    };

    return (
        <ActionToolbarPortal>
            <AnalyticsFavoriteIconButton isAnalyticsConfigured={true} isFavorite={isFavorite} isUpdating={isUpdating} onFavoriteClick={onFavoriteClick} />
            <DotButton data-testid="back-btn" onClick={handleBackClick} startIcon={<DotIcon iconId="back" />} type="outlined">
                Back
            </DotButton>
        </ActionToolbarPortal>
    );
};
