import { put } from 'redux-saga/effects';
import { registerSidebarProvider, SidebarProvider } from '../../../../../../../../../../core/xlr-ui/app/features/custom-ui/sidebar.registry';
import { navigation } from '../../../../../../../../../../core/xlr-ui/app/features/main-navigation/ducks/navigation.reducer';

const { setBackItem, updateBreadcrumbs, setSidebarMenu, setLastBreadcrumb } = navigation.actions;

export class AnalyticsSidebarProvider implements SidebarProvider {
    isSupported(path: string): boolean {
        return path.startsWith('/analytics/');
    }

    *provide(_path: string) {
        const breadcrumbs = [
            { text: 'Dashboards', href: `/dashboards` },
            {
                text: 'Analytics',
                href: `/analytics`,
            },
        ];
        yield put(setLastBreadcrumb(undefined));
        yield put(updateBreadcrumbs(breadcrumbs));
        yield put(setSidebarMenu({ sidebarMenu: [], withFolder: false }));

        yield put(
            setBackItem({
                pathSuffix: 'analytics',
                title: 'Analytics',
                text: 'Analytics',
            }),
        );
    }
}

registerSidebarProvider(new AnalyticsSidebarProvider(), 0);
