import { AnalyticsCardData } from '../types';

export const INTELLIGENCE_SERVER_TITLE = 'Digital.ai Analytics';

export const ANALYTICS_CATEGORIES: string[] = ['DevOps COE', 'Engineering manager', 'Platform engineer', 'Platform product manager', 'Release manager'];

export const ANALYTICS_AUTHORS: string[] = ['Digital.ai'];

export const ANALYTICS_SAMPLE_CARDS: AnalyticsCardData[] = [
    {
        contentText:
            'Efficiently monitor team and application onboarding and maturation rates on the Digital.ai Release-orchestrated pipeline. Identify areas for improvement.',
        id: '1',
        hasFolderFilter: false,
        embeddingUrl: 'http',
        embeddingId: '1',
        externalId: 1,
        imageSrc: 'static/@project.version@/include/analytics-dashboard/assets/onboarding.svg',
        subtitle: ANALYTICS_AUTHORS[0],
        tags: [ANALYTICS_CATEGORIES[0]],
        title: 'Onboarding plan and progress',
    },
    {
        contentText: 'Leverage DORA metrics for DevOps insights, identify areas for improvement, and drive change in software development.',
        id: '2',
        hasFolderFilter: false,
        embeddingUrl: 'http',
        embeddingId: '2',
        externalId: 2,
        imageSrc: 'static/@project.version@/include/analytics-dashboard/assets/dora-metrics.svg',
        subtitle: ANALYTICS_AUTHORS[0],
        tags: [ANALYTICS_CATEGORIES[1]],
        title: 'DORA overview',
    },
    {
        contentText: 'Retrospective analysis of past release processes over time.',
        id: '3',
        hasFolderFilter: false,
        embeddingUrl: 'http',
        embeddingId: '3',
        externalId: 3,
        imageSrc: 'static/@project.version@/include/analytics-dashboard/assets/executive.svg',
        subtitle: ANALYTICS_AUTHORS[0],
        tags: [ANALYTICS_CATEGORIES[4]],
        title: 'Release executive overview',
    },
    {
        contentText:
            'Monitor open tasks, address aged incomplete and dependent tasks. Review upcoming tasks for planning, prioritization, and adjustment for successful releases.',
        id: '4',
        hasFolderFilter: false,
        embeddingUrl: 'http',
        embeddingId: '4',
        externalId: 4,
        imageSrc: 'static/@project.version@/include/analytics-dashboard/assets/analysis.svg',
        subtitle: ANALYTICS_AUTHORS[0],
        tags: [ANALYTICS_CATEGORIES[4]],
        title: 'Release task open work analysis',
    },
    {
        contentText: 'Overview of release delays and dependencies related to Gate tasks.',
        id: '5',
        hasFolderFilter: false,
        embeddingUrl: 'http',
        embeddingId: '5',
        externalId: 5,
        imageSrc: 'static/@project.version@/include/analytics-dashboard/assets/late-task.svg',
        subtitle: ANALYTICS_AUTHORS[0],
        tags: [ANALYTICS_CATEGORIES[4]],
        title: 'Release late task and its impact',
    },
    {
        contentText: 'By revealing the impact of downstream actions on releases, this report empowers release managers to take proactive operational measures.',
        id: '6',
        hasFolderFilter: false,
        embeddingUrl: 'http',
        embeddingId: '6',
        externalId: 6,
        imageSrc: 'static/@project.version@/include/analytics-dashboard/assets/dependency.svg',
        subtitle: ANALYTICS_AUTHORS[0],
        tags: [ANALYTICS_CATEGORIES[4]],
        title: 'Release dependency dashboard',
    },
    {
        contentText:
            'Gain insights on team adoption of services and automation via Workflows. Identify what works best and manage your developer platform as a product.',
        id: '7',
        hasFolderFilter: false,
        embeddingUrl: 'http',
        embeddingId: '7',
        externalId: 7,
        imageSrc: 'static/@project.version@/include/analytics-dashboard/assets/workflow.svg',
        subtitle: ANALYTICS_AUTHORS[0],
        tags: [ANALYTICS_CATEGORIES[2], ANALYTICS_CATEGORIES[3]],
        title: 'Workflow adoption and usage patterns',
    },
];
