import React, { useEffect } from 'react';
import { Provider } from 'react-redux';
import { DotProgress, DotThemeProvider } from '@digital-ai/dot-components';
import { store } from '../../../analytics-store';
import { useAppDispatch, useAppSelector } from '../../../../../../../../../../core/xlr-ui/app/js/hooks';
import { getNavigationState } from '../../../../../../../../../../core/xlr-ui/app/features/main-navigation/ducks/navigation.selectors';
import { analytics, getAnalyticsState } from '../../ducks/analytics.reducer';
import { AnalyticsDashboardPagePortal } from './analytics-dashboard-page.portal';
import { useCloseSidebar } from '../../../../../../../../../../core/xlr-ui/app/features/common/hooks';
import { Folder } from '../../../../../../../../../../core/xlr-ui/app/types';
import './analytics-dashboard-page.component.less';

const { loadDashboard, clearSelectedDashboard } = analytics.actions;

export const dashboardDivId = 'dashboard-placeholder';

export interface AnalyticsDashboardPageProps {
    dashboardId: string;
    folder?: Folder;
}

export const AnalyticsDashboardPageProvider = (props: AnalyticsDashboardPageProps) => {
    return (
        <Provider store={store}>
            <DotThemeProvider>
                <AnalyticsDashboardPage {...props} />
            </DotThemeProvider>
        </Provider>
    );
};
export const AnalyticsDashboardPage = ({ dashboardId, folder }: AnalyticsDashboardPageProps) => {
    const { menuIsOpen } = useAppSelector(getNavigationState);
    const { selectedDashboard } = useAppSelector(getAnalyticsState);
    const dispatch = useAppDispatch();

    if (folder) {
        // TODO check permissions
    }

    useCloseSidebar(menuIsOpen, dispatch);
    useEffect(() => {
        dispatch(loadDashboard(dashboardId));
        return () => {
            dispatch(clearSelectedDashboard());
        };
    }, []);

    const renderLoader = () => {
        return (
            <div className="dashboard-loader">
                <DotProgress ariaLabel="Loading dashboard data" size={100} />
            </div>
        );
    };

    return (
        <div className="analytics-dashboard-page">
            <AnalyticsDashboardPagePortal dashboardId={dashboardId} folderId={folder?.id} />
            {selectedDashboard && <div id={dashboardDivId}></div>}
            {!selectedDashboard && renderLoader()}
        </div>
    );
};
